<?php
// 自定义菜单
register_nav_menus(
array(
'header-menu' => __( '导航自定义菜单' ),
'footer-menu' => __( '页角自定义菜单' )
)
);

// 添加侧边栏功能
if ( function_exists('register_sidebar') )
    register_sidebar();

// 自定义域
function head_JS_CSS(){
if (is_single() || is_page()) {
global $post;
$head_JS_CSS = get_post_meta($post->ID, 'head_JS_CSS', true);
echo $head_JS_CSS;
}
}

add_action("wp_head","head_JS_CSS");

// 短代码
// -- MP3播放器 start -------------------------------
function mp3player($atts, $content=null){
	extract(shortcode_atts(array("auto"=>'0'),$atts));	
	return '<embed src="'.get_bloginfo("template_url").'/addon/mp3player.swf?url='.$content.'&amp;autoplay='.$auto.'" type="application/x-shockwave-flash" wmode="transparent" allowscriptaccess="always" width="400" height="30">';
}
add_shortcode('mp3','mp3player');

// 分页列表
function par_pagenavi($range = 9){
	global $paged, $wp_query;
	if ( !$max_page ) {$max_page = $wp_query->max_num_pages;}
	if($max_page > 1){if(!$paged){$paged = 1;}
	if($paged != 1){echo "<a href='" . get_pagenum_link(1) . "' class='extend' title='跳转到首页'> 返回首页 </a>";}
	previous_posts_link(' 上一页 ');
    if($max_page > $range){
		if($paged < $range){for($i = 1; $i <= ($range + 1); $i++){echo "<a href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " class='current'";echo ">$i</a>";}}
    elseif($paged >= ($max_page - ceil(($range/2)))){
		for($i = $max_page - $range; $i <= $max_page; $i++){echo "<a href='" . get_pagenum_link($i) ."'";
		if($i==$paged)echo " class='current'";echo ">$i</a>";}}
	elseif($paged >= $range && $paged < ($max_page - ceil(($range/2)))){
		for($i = ($paged - ceil($range/2)); $i <= ($paged + ceil(($range/2))); $i++){echo "<a href='" . get_pagenum_link($i) ."'";if($i==$paged) echo " class='current'";echo ">$i</a>";}}}
    else{for($i = 1; $i <= $max_page; $i++){echo "<a href='" . get_pagenum_link($i) ."'";
    if($i==$paged)echo " class='current'";echo ">$i</a>";}}
	next_posts_link(' 下一页 ');
    if($paged != $max_page){echo "<a href='" . get_pagenum_link($max_page) . "' class='extend' title='跳转到最后一页'> 最后一页 </a>";}}
}
/* Gavatar 头像缓存 */
function get_cavatar($source) {
	$time = 1209600; //The time of cache(seconds)
	preg_match('/avatar\/([a-z0-9]+)\?s=(\d+)/',$source,$tmp);
	$abs = ABSPATH.'avatar/'.$tmp[1].'.jpg';
	$url = get_bloginfo('wpurl').'/avatar/'.$tmp[1].'.jpg';
	$default = get_bloginfo('wpurl').'/avatar/'.'default.jpg';
	if (!is_file($abs)||(time()-filemtime($abs))>$time){
		copy('http://www.gravatar.com/avatar/'.$tmp[1].'?s=64&d='.$default.'&r=G',$abs);
	}
	if (filesize($abs)<500) { copy($default,$abs); }
	return '<img alt="" src="'.$url.'" class="avatar avatar-'.$tmp[2].'" width="'.$tmp[2].'" height="'.$tmp[2].'" />';
}
add_filter('get_avatar','get_cavatar');

//comment_mail_notify(所有的回复都会发邮件通知)
function comment_mail_notify($comment_id) {
  $comment = get_comment($comment_id);
  $parent_id = $comment->comment_parent ? $comment->comment_parent : '';
  $spam_confirmed = $comment->comment_approved;
  if (($parent_id != '') && ($spam_confirmed != 'spam')) {
    $wp_email = 'no-reply@' . preg_replace('#^www.#', '', strtolower($_SERVER['SERVER_NAME']));//发件人e-mail地址
    $to = trim(get_comment($parent_id)->comment_author_email);
    $subject = '您在['.get_option("blogname").']的留言有了回复';
    $message = '
    <div style="background-color:#eef2fa; border:1px solid #d8e3e8; color:#111; padding:0 15px; -moz-border-radius:5px; -webkit-border-radius:5px; -khtml-border-radius:5px;">
      <p>'.trim(get_comment($parent_id)->comment_author).', 您好!</p>
      <p>这是您在《'.get_the_title($comment->comment_post_ID).'》中的留言:'
       .trim(get_comment($parent_id)->comment_content).'</p>
      <p>以下是'.trim($comment->comment_author).' 给您的回复:'
       .trim($comment->comment_content).'<br /></p>
      <p>您可以<a href="' . htmlspecialchars(get_comment_link($parent_id)) . '">点击这里查看回复的完整内容.</a></p>
      <p>欢迎再度光临 <a href="' . get_option('home') . '">' . get_option('blogname') . '</a></p>
      <p>(注:此邮件由系统自动发出,请勿回复!)</p>
    </div>';
    $headers = "$fromnContent-Type: text/html; charset=" . get_option('blog_charset') . "n";
    wp_mail( $to, $subject, $message, $headers );
    //echo 'mail to ', $to, '<br/> ' , $subject, $message; // for testing
  }
}
add_action('comment_post', 'comment_mail_notify');

// Custom Comments List.
function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment;
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<span class="squ-avatar">
			<?php echo get_avatar($comment->comment_author_email,40); ?>
			</span>
			<span class="squ-commeta"><?php comment_author_link() ?>
			<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'),'  ','') ?></span>
<span class="squ-comreply">
			<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
		</span>
		</div>
		<?php if ($comment->comment_approved == '0') : ?>
		<em class="approved"><?php _e('Your comment is awaiting moderation.') ?></em>
		<br />
		<?php endif; ?>
		<div class="comment-text">
			<?php comment_text() ?>
		</div>
		</div>
<?php } ?>